<?php
/*=======================================================================*\
|| ##################################################################### ||
|| # vBCredits II Deluxe 2.1.0 - `credits_core.php`					   # ||
|| # ------------------------------------------------------------------# ||
|| # Author: Darkwaltz4 {blackwaltz4@msn.com}						   # ||
|| # Copyright © 2009 - 2012 John Jakubowski. All Rights Reserved.	   # ||
|| # This file may not be redistributed in whole or significant part.  # ||
|| # -----------------vBulletin IS NOT FREE SOFTWARE!------------------# ||
|| #			 Support: http://www.dragonbyte-tech.com/			   # ||
|| ##################################################################### ||
\*=======================================================================*/
//delete user deletes stuff, others?

global $vb4;//flag used everywhere
$vb4 = (substr($vbulletin->options['templateversion'], 0, 1) == '4'); //compatibility flag
$datastore_fetch = array_merge((array) $datastore_fetch, array("'vbcredits'", "'max_allowed_packet'"));

if (method_exists('vBulletinHook', 'set_pluginlist') AND $vbulletin->options['credits_version'] != '2.1.0')
{	//wont cause errors about file/database mismatch
	//vBulletinHook::set_pluginlist('');
}

class VBCREDITS
{
	var $queue = array();
	var $insert = array();
	var $myself = array();
	var $douser = false;

	function &init()
	{	//static wrapper
		static $instance;
		if (!$instance) $instance = new VBCREDITS();
		return $instance;
	}

	function user(&$fields, &$joins, $whitelist = array('user', 'userfield', 'usertextfield'), $weight = false)
	{	//load the user's credits
		static $query;
		global $vbulletin;
		$cid = md5(serialize($whitelist) . intval($weight));

		if (empty($query[$cid]) AND is_array($vbulletin->vbcredits['currency']))
		{	//only calculate if not cached; oldlastvisit used for timer actions
			$query[$cid] = array('', '');

			foreach ($vbulletin->vbcredits['currency'] AS $currencyid => $currency)
			{	//determine whether to join table
				$table = ( ($dojoin = in_array($currency['table'], $whitelist)) ? $currency['table'] : 'vbcreditst_' . $currencyid );
				$query[$cid][0] .= ( $weight ? ' +' : ',' ) . ' (' . $table . '.' . $currency['column'] . ( $weight ? ')' : ') AS vbcredits_' . $currencyid . ', ' . $table . '.' . $currency['column'] . ' AS vbcreditsb_' . $currencyid );
				if (!$dojoin) $query[$cid][1] .= ' LEFT JOIN ' . ( $currency['useprefix'] ? TABLE_PREFIX : '' ) . $currency['table'] . ' AS ' . $table . ' ON (user.' . ( $currency['userid'] ? 'userid' : 'username' ) . ' = ' . $table . '.' . $currency['usercol'] . ') ';
			}
		}

		$fields .= $query[$cid][0];
		$joins .= $query[$cid][1];
	}

	function verify(&$cronimage, $cbf = false)
	{
		global $vbulletin, $vb4;

		if ($vbulletin->options['credits_branding_free'] != '{|[DBTech!Branding?Removal#Key~vBCredits]|}' AND empty($cbf))
		{
			$copyright = '<div><a href="http://www.dragonbyte-tech.com/product.php?credits" target="_blank">vBCredits II Deluxe</a>' . ( $vbulletin->options['credits_display_version'] ? ' v2.1.0 (Lite)' : '' ) . ' - <a href="http://www.dragonbyte-tech.com" target="_blank">vBulletin Mods &amp; Addons</a> Copyright &copy; ' . ( ($year = date('Y') AND $year != '2010') ? '2010-' : '' ) . $year . ' DragonByte Technologies Ltd.' . ( !$vbulletin->options['credits_disablefooter'] ? '<br />Runs best on <a href="http://www.hivelocity.net/?utm_source=Iain%2BKidd&utm_medium=back%2Blink&utm_term=Dedicated%2BServer%2BSponsor&utm_campaign=Back%2BLinks%2Bfrom%2BIain%2BKidd" target="_blank">HiVelocity Hosting</a>.' : '' ) . '</div>';
			if ($vb4) $cronimage .= $copyright; else $vbulletin->templatecache['footer'] = str_replace('$cronimage', addslashes('$cronimage' . $copyright), $vbulletin->templatecache['footer']);
		}
		if ($vbulletin->userinfo['userid'])
		{	//only users have transactions
			$trans = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "credits_pending WHERE checkstamp <= " . TIMENOW . " AND userid = " . $vbulletin->userinfo['userid'] . " ORDER BY checkstamp ASC LIMIT 1");
			VBCREDITS::process($trans, $vbulletin->userinfo);
		}
	}

	function snapshot()
	{	//current user's currencies
		global $vbulletin;
		$obj =& VBCREDITS::init();
		$userinfo =& $vbulletin->userinfo;

		foreach ($vbulletin->vbcredits['currency'] AS $currencyid => $currency)
		{	//use offset as userinfo gets lost
			$obj->myself[$currencyid] += $userinfo['vbcredits_' . $currencyid] - $userinfo['vbcreditsb_' . $currencyid];
			$userinfo['vbcredits_' . $currencyid] = $userinfo['vbcreditsb_' . $currencyid];
		}

		return $obj->myself;
	}

	function process($trans, &$userinfo)
	{
		global $vbulletin, $vb4;
		$obj =& VBCREDITS::init();
		$db =& $vbulletin->db;
		$count = array(); $status = 1;

		if ($userinfo['userid'] AND $trans)
		{
			if ($trans['eventid'])
			{
				$perms = ( is_array($userinfo['creditspermissions']) ? $userinfo['creditspermissions'] : ( $userinfo['creditspermissions'] ? unserialize($userinfo['creditspermissions']) : array(array(), array()) ) );

				if (!in_array($trans['currencyid'], $perms[0]) AND !($userinfo['permissions']['creditspermissions'] & $vbulletin->bf_ugp_creditspermissions['credits_locked']))
				{
					$events =& $vbulletin->vbcredits['event'][$trans['actionid']][$trans['currencyid']];
					$event =& $events[$trans['eventid']];
					if ($event['moderate']) $status = 2;

					if ($status == 1)
					{	//i should get it now
						$userinfo['vbcredits_' . $trans['currencyid']] += $trans['amount'];//other things call update
						if ($vbulletin->userinfo['userid'] == $userinfo['userid']) VBCREDITS::snapshot();
					}
				}
			}	//this one needs to be resent as the owner
			else VBCREDITS::action($trans['actionid'], $trans['userid'], $trans['referenceid'], $trans['negate'], array('userinfo' => $userinfo) + array_intersect_key($trans, array('message' => true, 'multiplier' => true, 'timestamp' => true, 'currencyid' => true, 'forumid' => true, 'ownerid' => true)));

			if ($trans['transactionid'])
			{	//delayed processing
				if (is_null($trans['referenceid'])) $trans['referenceid'] = 'NULL'; else if (!is_numeric($trans['referenceid'])) $trans['referenceid'] = "'" . $db->escape_string($trans['referenceid']) . "'";
				if ($trans['eventid']) $db->query_write("INSERT INTO " . TABLE_PREFIX . "credits_transaction " . VBCREDITS::sql($trans['status'] = $status) . " VALUES " . VBCREDITS::sql($trans));
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "credits_pending WHERE transactionid = " . $trans['transactionid']);
			}	//realtime processing
			else return $status;
		}
	}

	function templates(&$cache)
	{
		global $vbulletin;
		$cache[] = 'credits_popup';
		$cache[] = 'credits_navtab';

		if (empty($vbulletin->vbcredits))
		{	//fix broken caches
			vbcredits_cache();
		}
		if (is_array($vbulletin->vbcredits['display']))
		{
			foreach ($vbulletin->vbcredits['display'] AS $display)
			{	//add any display templates
				if (empty($display['showpages']) OR in_array(THIS_SCRIPT, explode(',', $display['showpages'])))
				{
					if (!in_array($display['row_template'], $cache)) $cache[] = $display['row_template'];
					if ($display['main_template'] AND !in_array($display['main_template'], $cache)) $cache[] = $display['main_template'];
				}
			}
		}
	}

	function display($displayid, $user, &$hooks)
	{	//get the profile and process according to thingy
		global $vbulletin, $permissions, $vb4, $vbphrase;

		if (is_array($vbulletin->vbcredits['display']) AND array_key_exists($displayid, $vbulletin->vbcredits['display']))
		{
			$display =& $vbulletin->vbcredits['display'][$displayid];
			if ($vbulletin->userinfo['userid']) $action =& $vbulletin->vbcredits['action'][$display['actionid']];
			$showhide = ($user['permissions']['creditspermissions'] & $vbulletin->bf_ugp_creditspermissions['credits_hidden']);
			$currencies = '';

			if ($user['userid'] AND (!($user['permissions']['creditspermissions'] & $vbulletin->bf_ugp_creditspermissions['credits_locked']) OR $showhide))
			{	//member and (not locked or show hidden)
				if ($vb4)
				{	//vb4 template registration
					$t = vB_Template::create($display['row_template']);
					$t->register('display', $display);
					$t->register('action', $action);
					$t->register('user', $user);
					$t->register('vb4', $vb4);
				}

				$perms = ( is_array($user['creditspermissions']) ? $user['creditspermissions'] : ( $user['creditspermissions'] ? unserialize($user['creditspermissions']) : array(array(), array()) ) );
				$special = ($permissions['creditspermissions'] & $vbulletin->bf_ugp_creditspermissions['credits_special']);
				$myself = ($user['userid'] == $vbulletin->userinfo['userid']);
				$obj =& VBCREDITS::init();
				$comboamt = 0;

				if (is_array($vbulletin->vbcredits['currency']))
				{
					foreach ($vbulletin->vbcredits['currency'] AS $currencyid => $currency)
					{
						$useramt = $user['vbcredits_' . $currencyid] + ( $myself ? $obj->myself[$currencyid] : 0 );
						if ($display['combine'] AND (empty($display['combined']) OR in_array($currencyid, $display['combined']))) $comboamt += $useramt;

						if ((empty($display['currencies']) OR in_array($currencyid, $display['currencies'])) AND ($currency['privacy'] == 2 OR ($special OR ($myself AND $currency['privacy'] == 1))) AND ($showhide OR (!in_array($currencyid, $perms[0]) OR !in_array($currencyid, $perms[1]))))
						{	//this currency is included and privacy settings fit and showhide or i can spend or earn this currency
							if ($useramt < 0 AND $currency['negative'] == 1) $useramt = 0;
							$useramt = fetch_word_wrapped_string(vb_number_format($useramt, $currency['decimals']));
							if ($useramt[0] == '-' AND !strlen(preg_replace('/[^1-9]/', '', $useramt))) $useramt = substr($useramt, 1);//-0

							if ($currency['decimals'])
							{	//might need to pad the decimals
								$useramt = explode($vbulletin->userinfo['lang_decimalsep'], $useramt);
								$useramt = $useramt[0] . $vbulletin->userinfo['lang_decimalsep'] . str_pad($useramt[1], $currency['decimals'], '0');
							}
							if ($vb4)
							{
								$t->register('currency', $currency);
								$t->register('useramt', $useramt);
								$currencies .= $t->render();
							}
							else eval('$currencies .= "' . fetch_template($display['row_template']) . '";');
						}
					}
				}
				if ($display['combine'])
				{	//add the combination row
					$currency['title'] = $display['combine']; //fake it
					$useramt = fetch_word_wrapped_string(vb_number_format($comboamt, $display['combodec']));

					if ($vb4)
					{
						$t->register('currency', $currency);
						$t->register('useramt', $useramt);
						$currencies .= $t->render();
					}
					else eval('$currencies .= "' . fetch_template($display['row_template']) . '";');
				}
			}
			if ($currencies)
			{	//if anything to show, then wrap and return
				if ($display['wrap_main'] AND $display['main_template'])
				{	//apply wrapper template
					if ($vb4)
					{
						$t = vB_Template::create($display['main_template']);
						$t->register('user', $user);
						$t->register('display', $display);
						$t->register('currencies', $currencies);
						$t->register('vb4', $vb4);
						$currencies = $t->render();
					}
					else eval('$currencies = "' . fetch_template($display['main_template']) . '";');
				}
				if ($display['hookname'] AND is_array($hooks))
				{	//if its a custom hook, replace the whole hook
					if ($display['customhook']) $hooks[$display['hookname']] = $currencies;
					else $hooks[$display['hookname']] .= $currencies;
				}
				else return $currencies; //attached to hook or just returned
			}
		}

		return '';
	}

	function regular()
	{
		require_once(DIR . '/includes/adminfunctions.php');
		require_once(DIR . '/includes/functions_misc.php');
		global $vb4, $vbulletin, $permissions, $footer, $vbphrase;

		if ($vbulletin->userinfo['userid'] AND !empty($vbulletin->vbcredits['currency']))
		{
			$options = $doacts = $tocurs = $fromcurs = $valopts = array();
			$intref = explode('-', $vbulletin->options['credits_action_interest_start']);
			$refdate = vbmktime(0, 0, 0, intval($intref[1]), intval($intref[2]), intval($intref[0]));
			$interval = ($vbulletin->options['credits_action_interest_interval'] * 86400);
			$part = (abs($vbulletin->userinfo['lastactivity'] - $refdate) % $interval);
//hook?
			foreach ($vbulletin->vbcredits['currency'] AS $currencyid => $currency)
			{
				$actions = array();

				for ($stamp = $vbulletin->userinfo['lastactivity'] + $interval - ( ($vbulletin->userinfo['lastactivity'] < $refdate) ? $interval - $part : $part ); $stamp <= TIMENOW; $stamp += $interval)
				{	//give all the missed interest
					VBCREDITS::action('interest', $vbulletin->userinfo['userid'], null, false, array('timestamp' => $stamp, 'currencyid' => $currencyid, 'multiplier' => $vbulletin->userinfo['vbcreditsb_' . $currencyid]));
				}

				if (sizeof($vbulletin->vbcredits['event']['donate'][$currencyid]) OR sizeof($vbulletin->vbcredits['event']['transfer'][$currencyid]))
				{
					$curs = array();

					foreach ($vbulletin->vbcredits['currency'] AS $curid => $cury)
					{
						if ($curid == $currencyid AND (sizeof($vbulletin->vbcredits['event']['donate'][$curid]) OR sizeof($vbulletin->vbcredits['event']['transfer'][$curid])))
						{	//note first part falls off for lite
							$fromcurs[$curid] = $cury['title'];
							$curs[] = $curid;
						}
					}
					if (sizeof($curs))
					{
						$doacts['transfer'] = $vbulletin->vbcredits['action']['transfer']['title'];
						$actions['transfer'] = '"transfer":[' . implode(',', $curs) . ']';
					}
				}

				if (sizeof($vbulletin->vbcredits['event']['adjust'][$currencyid]) AND ($permissions['creditspermissions'] & $vbulletin->bf_ugp_creditspermissions['credits_adjust']))
				{
					$doacts['adjust'] = $vbulletin->vbcredits['action']['adjust']['title'];
					$actions['adjust'] = '"adjust":[]';
				}
//hook?
				if (sizeof($actions))
				{
					$tocurs[$currencyid] = $currency['title'];
					$options[$currencyid] = '"' . $currencyid . '":{' . implode(',', $actions) . '}';
				}
			}
			if (sizeof($options))
			{
				if ($vbulletin->options['credits_action_transfer_increments'])
				{	//dont make blank options
					foreach (explode(',', $vbulletin->options['credits_action_transfer_increments']) AS $val)
					{	//create nice array of numeric values that keep decimals
						$valopts[$val = doubleval($val)] = vb_number_format($val, ( (strpos($val, '.') !== false) ? strlen(array_pop(explode('.', $val))) : 0 ));
					}
				}

				$options = '{' . implode(',', $options) . '}';
				$doacts = construct_select_options($doacts);
				$tocurs = construct_select_options($tocurs);
				$fromcurs = construct_select_options($fromcurs);
				$valopts = construct_select_options($valopts);
//hook? template hook?
				if ($vb4)
				{
					if (!in_array($vbulletin->userinfo['styleid'], array($vbulletin->options['mobilestyle_basic'], $vbulletin->options['mobilestyleid_advanced'])))
					{	//dont enable for mobile
						$t = vB_Template::create('credits_popup');
						$t->register('options', $options);
						$t->register('doacts', $doacts);
						$t->register('tocurs', $tocurs);
						$t->register('fromcurs', $fromcurs);
						$t->register('valopts', $valopts);
						$t->register('vb4', $vb4);
						$footer .= $t->render();
					}
				}
				else eval('$footer .= "' . fetch_template('credits_popup') . '";');
			}
		}
	}

	function shutdown()
	{
		global $vbulletin;
		$obj =& VBCREDITS::init();
		if (sizeof($obj->insert)) VBCREDITS::commit();
		if (sizeof($obj->myself)) VBCREDITS::update($vbulletin->userinfo, true);
		$obj->myself = array();
	}

	function update(&$userinfo, $myself = false)
	{	//string together all the currencies to update unbuffered
		if ($userinfo['userid'])
		{
			global $vbulletin;
			$db =& $vbulletin->db;
			$obj =& VBCREDITS::init();
			$query = array(array(), array(), array());

			foreach ($vbulletin->vbcredits['currency'] AS $currencyid => $currency)
			{
				$table = 'vbcreditst_' . $currencyid;
				$query[0][] = ( $currency['useprefix'] ? TABLE_PREFIX : '' ) . $currency['table'] . ' AS ' . $table;
				$query[1][] = $table . '.' . $currency['column'] . ' = ' . ( $myself ? $table . '.' . $currency['column'] . ' + ' . doubleval($obj->myself[$currencyid]) : doubleval($userinfo['vbcredits_' . $currencyid]) );
				$query[2][] = $table . '.' . $currency['usercol'] . ' = ' . ( $currency['userid'] ? $userinfo['userid'] : "'" . $db->escape_string(htmlspecialchars_uni($userinfo['username'])) . "'" );
			}

			$db->query_write("UPDATE " . implode(', ', $query[0]) . " SET " . implode(', ', $query[1]) . " WHERE " . implode(' AND ', $query[2]), false);
		}
	}

	function action($actionid, $userid, $refid = null, $negate = false, $extra = array())
	{	//if you have a refid send it, if you will have one send true, if you wont have one leave it as null
		global $vbulletin, $vbphrase, $multiplier;
		static $sizetext = array();
		$obj =& VBCREDITS::init();
		$queue = array();

		if ($vbulletin->options['credits_enabled'] AND $userid AND is_array($vbulletin->vbcredits['action']) AND array_key_exists($actionid, $vbulletin->vbcredits['action']) AND is_array($vbulletin->vbcredits['event']) AND array_key_exists($actionid, $vbulletin->vbcredits['event']))
		{	//events are enabled and exist plus skip unused actions
			if (!$sizetext)
			{	//size mult labels
				global $vbphrase;
				$sizetext = 'credits_size_' . ( $vbulletin->options['credits_size_words'] ? 'word' : 'char' );
				$sizetext = array($vbphrase[$sizetext . 's'], $vbphrase[$sizetext]);//size mult labels
			}

			$action =& $vbulletin->vbcredits['action'][$actionid];
			$usesize = ($action['multiplier'] == 'Size');
			$multlabel = ( $usesize ? $sizetext : explode('|', $action['multiplier'], 2) );
			$message = ( array_key_exists('message', $extra) ? $extra['message'] : '' );
			$timestamp = ( empty($extra['timestamp']) ? TIMENOW : intval($extra['timestamp']) );
			$multiplier = ( $usesize ? vbcredits_size($extra['multiplier']) : ( is_numeric($extra['multiplier']) ? $extra['multiplier'] : 0 ) );

			if ($notmyself = ($vbulletin->userinfo['userid'] != $userid) AND is_array($extra['userinfo'])) $userinfo = $extra['userinfo'];
			else $userinfo =& $vbulletin->userinfo;

			$currencyid = intval($extra['currencyid']);
			$ownerid = intval($extra['ownerid']);
			$forumid = intval($extra['forumid']);
			$sfx = ( $negate ? '_sub' : '_add' );
			unset($extra);//save memory

			if ($userid == $userinfo['userid'])
			{	//narrow down to specific currency if selected
				$currencies = ( ($currencyid AND is_array($vbulletin->vbcredits['currency']) AND array_key_exists($currencyid, $vbulletin->vbcredits['currency'])) ? array($currencyid => $vbulletin->vbcredits['currency'][$currencyid]) : $vbulletin->vbcredits['currency'] );
				$perms = ( is_array($userinfo['creditspermissions']) ? $userinfo['creditspermissions'] : ( $userinfo['creditspermissions'] ? unserialize($userinfo['creditspermissions']) : array(array(), array()) ) );

				if (is_array($currencies))
				{
					foreach ($currencies AS $currencyid => $currency)
					{	//returns the best eventid for the criteria
						$events = array();

						foreach ((array) $vbulletin->vbcredits['event'][$actionid][$currencyid] AS $eventid => $event)
						{
							if ((empty($event['forums']) OR in_array($forumid, $event['forums'])) AND (empty($event['usergroups']) OR is_member_of($userinfo, $event['usergroups'])) AND (!$action['parent'] OR is_null($event['owner']) OR $event['owner'] == intval($userid == $ownerid)))
							{	//event applies to my group and forum
								$events[$eventid] = $event['main' . $sfx];
							}
						}
						if ($vbulletin->options['credits_best_event'] AND sizeof($events))
						{	//pick best one
							arsort($events);
							$events = array(key($events) => array_shift($events));
						}
						foreach ($events AS $eventid => $amount)
						{	//picked best one
							$event =& $vbulletin->vbcredits['event'][$actionid][$currencyid][$eventid];
							$now = ($timestamp == TIMENOW);
							$status = 0; //pending

							if ($action['multiplier'] OR $action['currency'])
							{	//this action has multipliers
								$amult = ( ($nmult = ($multiplier < 0)) ? -1 : 1 ) * $multiplier;

								if (is_null($event['multmin']) OR $amult >= $event['multmin'])
								{	//within the bounds - check if multiplier was negative
									$multiplier = ( (is_null($event['multmax']) OR $amult <= $event['multmax']) ? $multiplier : ( $nmult ? -1 : 1 ) * $event['multmax'] );

									if ($action['currency'])
									{	//only apply adjustments if applicable
										$doadjust = ($event['curtarget'] == 2 OR ($event['curtarget'] == 1 XOR ($nmult XOR $negate)));
										$amount = ( $doadjust ? $amount : 0 ) + $multiplier * (1 + $doadjust * $event['mult' . $sfx]);
									}	//otherwise now
									else $amount += $multiplier * $event['mult' . $sfx];
								}
								else if ($event['minaction'] == 1)
								{	//skip the event
									continue;
								}
								else if (!$negate AND $event['minaction'] == 2)
								{	//stop the action
									if ($now AND $action['cancel'])
									{	//action is cancelable, show error
										eval(standard_error(fetch_error("credits_cancel_mult_$actionid", vb_number_format($event['multmin'], ( (strpos($event['multmin'], '.') !== false) ? strlen(array_pop(explode('.', $event['multmin']))) : 0 )), ( $action['currency'] ? $currency['title'] : $multlabel[intval($event['multmin'] == 1)] ))));
									}
									else return false;
								}
							}
							if ($amount < 0)
							{	//paying credits, apply now
								$status = 1;
								$posamount = -1 * $amount;

								if ($now AND !$negate AND $action['cancel'] AND ($posamount > ($userinfo['vbcredits_' . $currencyid] + ( !$notmyself ? $obj->myself[$currencyid] : 0 )) OR in_array($currencyid, $perms[1]) OR ($userinfo['permissions']['creditspermissions'] & $vbulletin->bf_ugp_creditspermissions['credits_locked'])))
								{	//not enough credits or cant spend this and action is cancelable - show error
									eval(standard_error(fetch_error("credits_cancel_price_$actionid", fetch_word_wrapped_string(vb_number_format($posamount, $currency['decimals'])), $currency['title'])));
								}
								else $userinfo['vbcredits_' . $currencyid] -= $posamount;
							}
							if ($amount != 0)
							{	//store events that affect creditsv
								$queue[] = array(
									'eventid' => $eventid, 'actionid' => $actionid, 'currencyid' => $currencyid,
									'userid' => $userid, 'timestamp' => $timestamp, 'checkstamp' => $timestamp,
									'amount' => $amount, 'status' => $status, 'referenceid' => '', 'negate' => $negate,
									'forumid' => $forumid, 'ownerid' => $ownerid, 'multiplier' => $multiplier, 'message' => $message
								);
							}
						}
					}
				}
			}
			else
			{	//unknown - user will have to load it later
				$queue[] = array(
					'eventid' => 0, 'actionid' => $actionid, 'currencyid' => $currencyid,
					'userid' => $userid, 'timestamp' => $timestamp, 'checkstamp' => $timestamp,
					'amount' => 0, 'status' => 0, 'referenceid' => '', 'negate' => $negate,
					'forumid' => $forumid, 'ownerid' => $ownerid, 'multiplier' => $multiplier, 'message' => $message
				);
			}
			if (sizeof($queue))
			{	//dont bother saving guest stuff
				$queueid = sizeof($obj->queue);
				$obj->queue[] = $queue;

				foreach ($vbulletin->vbcredits['currency'] AS $currencyid => $currency)
				{	//currency doesnt like negative
					$useramt =& $userinfo['vbcredits_' . $currencyid];
					if ($useramt < 0 AND $currency['negative'] == 0) $useramt = 0;
				}

				if ($notmyself) VBCREDITS::update($userinfo);
				else VBCREDITS::snapshot();

				if ($refid !== true)
				{	//if we have a refid use it
					VBCREDITS::apply($queueid, $refid);
					return;
				}	//or queue for later
				else return $queueid;
			}
		}

		return false;
	}

	function apply($queueid, $refid)
	{	//we got back the refid, queue the inserts
		if (is_numeric($queueid))
		{	//only if queueid is valid
			static $sqlbase;
			global $vbulletin, $db;
			$obj =& VBCREDITS::init();

			if (empty($sqlbase)) $sqlbase = 166 + strlen(TABLE_PREFIX);
			$sqlsize = $sqlbase; foreach ($obj->insert AS $i => $row) $sqlsize += strlen(VBCREDITS::sql($row)) + ( $i ? 2 : 0 );
			if (is_null($refid)) $refid = 'NULL'; else if (!is_numeric($refid)) $refid = "'" . $db->escape_string($refid) . "'";

			foreach ($obj->queue[$queueid] AS $count => $set)
			{	//clear out of queue, but leave the empty array
				$set['referenceid'] = $refid;
				$setsize = strlen(VBCREDITS::sql($set)) + ( sizeof($obj->insert) ? 2 : 0 );

				if ($vbulletin->max_allowed_packet AND ($sqlsize + $setsize) > $vbulletin->max_allowed_packet)
				{	//insert is too much, send it now and reset
					VBCREDITS::commit();
					$sqlsize = $sqlbase;
				}

				$sqlsize += $setsize;
				$obj->insert[] = $set;
				unset($obj->queue[$queueid][$count]);
			}
		}
	}

	function sql($tran = null)
	{	//generate the sql string for transaction
		static $keys = array(
			'eventid' => 'i', 'actionid' => 's', 'userid' => 'i', 'timestamp' => 'i', 'checkstamp' => 'i',
			'amount' => 'f', 'status' => 'i', 'referenceid' => '', 'forumid' => 'i', 'ownerid' => 'i',
			'multiplier' => 'f', 'currencyid' => 'i', 'negate' => 'i', 'message' => 's'
		);

		if (is_array($tran))
		{	//clean and format transaction
			global $db; $cols = $keys;
			if ($tran['status']) unset($cols['checkstamp']);
			else unset($cols['status']);

			foreach ($cols AS $key => $clean)
			{
				$field = $tran[$key];

				switch ($clean)
				{	//prep col for insert
					case 'i': $field = intval($field); break;
					case 'f': $field = doubleval($field); break;
					case 's': $field = "'" . $db->escape_string($field) . "'"; break;
				}

				$cols[$key] = $field;
			}
		}
		else
		{	//just return keys
			$cols = array_keys($keys);
			if ($tran) unset($cols[4]); else unset($cols[6]);
		}

		return '(' . implode(', ', $cols) . ')';
	}

	function commit()
	{	//apply unbuffered queries and reset array
		global $vbulletin, $db, $usercache, $vbphrase;
		$obj =& VBCREDITS::init();

		if (sizeof($obj->insert))
		{
			static $sender = null;
			$inserts = array(array(), array());

			foreach ($obj->insert AS $i => $trans)
			{
				if ($trans['eventid'])
				{	//only process events we know about
					$action =& $vbulletin->vbcredits['action'][$trans['actionid']];
					$currency =& $vbulletin->vbcredits['currency'][$trans['currencyid']];
					$event =& $vbulletin->vbcredits['event'][$trans['actionid']][$trans['currencyid']][$trans['eventid']];

					if ($notmyself = ($vbulletin->userinfo['userid'] != $trans['userid']))
					{	//load fresh cache each time
						unset($usercache[$trans['userid']], $userinfo);
						$userinfo = fetch_userinfo($trans['userid']);
						cache_permissions($userinfo, false);
					}	//myself should be up to date
					else $userinfo =& $vbulletin->userinfo;
					if ($vbulletin->options['credits_dangerous'] AND !$trans['status'] AND $status = VBCREDITS::process($trans, $userinfo))
					{	//realtime processing!
						if ($status == 1 AND $notmyself) VBCREDITS::update($userinfo);
						$trans['status'] = $status;
					}
				}

				$inserts[intval($trans['status'] > 0)][] = VBCREDITS::sql($trans);
			}
			foreach ($inserts AS $status => $insert)
			{	//send inserts to appropriate table
				if (sizeof($insert)) $db->query_write("INSERT INTO " . TABLE_PREFIX . "credits_" . ( $status ? 'transaction' : 'pending' ) . " " . VBCREDITS::sql($status) . " VALUES " . implode(', ', $insert), false);
			}

			$obj->insert = array();
		}
	}
}

function credits_events($actionid = '', $currencyid = 0, $array = false)
{
	global $vbulletin;
	$eventids = array();

	foreach ($vbulletin->vbcredits['event'] AS $aid => $currencies)
	{
		if (empty($actionid) OR $actionid == $aid)
		{
			foreach ($currencies AS $cid => $events)
			{
				if (empty($currencyid) OR $currencyid == $cid) $eventids = array_merge($eventids, array_keys($events));
			}
		}
	}
	foreach ($vbulletin->vbcredits['history'] AS $aid => $currencies)
	{
		if (empty($actionid) OR $actionid == $aid)
		{
			foreach ($currencies AS $cid => $events)
			{
				if (empty($currencyid) OR $currencyid == $cid) $eventids = array_merge($eventids, $events);
			}
		}
	}

	$eventids = array_unique($eventids);
	return ( $array ? $eventids : ( sizeof($eventids) ? 'eventid IN (' . implode(', ', $eventids) . ')' : '0' ) );
}

function credits_redeems($code, $user = false)
{
	global $vbulletin, $db;

	foreach ($vbulletin->vbcredits['redemption'] AS $currencyid => $redeems)
	{
		foreach ($redeems AS $redeem)
		{
			if ($redeem['startdate'] <= TIMENOW AND (!$redeem['enddate'] OR $redeem['enddate'] > TIMENOW) AND in_array($code, $redeem['codes']) AND (empty($redeem['usergroups']) OR is_member_of($vbulletin->userinfo, $redeem['usergroups'])))
			{	//exists for me
				if ($user)
				{
					$stats = $db->query_first("SELECT COUNT(DISTINCT userid) AS users, SUM(userid = " . $user['userid'] . ") AS total, SUM(referenceid = '" . $db->escape_string($code) . "') AS used FROM " . TABLE_PREFIX . "credits_transaction WHERE " . credits_events('redeem') . " AND referenceid IN ('" . implode("', '", $redeem['codes']) . "')");

					if ((sizeof($redeem['codes']) == 1 OR !$stats['used']) AND (!$redeem['maxtimes'] OR $stats['total'] < $redeem['maxtimes']) AND (!$redeem['maxusers'] OR $stats['users'] < $redeem['maxusers']))
					{	//code still very much valid
						$redeem['vbcredits'] = VBCREDITS::action('redeem', $user['userid'], true, false, array('currencyid' => $currencyid, 'multiplier' => $redeem['amount'], 'userinfo' => ( ($user['userid'] != $vbulletin->userinfo['userid']) ? $user : null ), 'ownerid' => $vbulletin->userinfo['userid'], 'message' => $vbulletin->userinfo['username'] . " used $code" . ( $vbulletin->GPC['note'] ? ': ' . $vbulletin->GPC['note'] : '' )));
						VBCREDITS::apply($redeem['vbcredits'], $code);
					}
				}

				return $redeem;
			}
		}
	}

	return false;
}

function vbcredits_size($text)//, $keepsmile = false
{	//fetches the size of the text according to settings
	global $vbulletin;
	$db =& $vbulletin->db;

	if ($vbulletin->options['credits_exclude_blocks'])
	{
		foreach (array('quote', 'php', 'html', 'code') AS $tag)
		{
			$start_pos = $end_pos = array();
			$lowertext = strtolower($text);
			$taglen = strlen($tag);
			$curpos = 0;

			do
			{
				$pos = strpos($lowertext, '[' . $tag, $curpos);

				if ($pos !== false AND ($lowertext[$pos + $taglen + 1] == '=' OR $lowertext[$pos + $taglen + 1] == ']'))
				{
					$start_pos["$pos"] = 'start';
				}

				$curpos = $pos + $taglen + 1;
			}
			while ($pos !== false);

			if (sizeof($start_pos) == 0) continue;
			$curpos = 0;

			do
			{
				$pos = strpos($lowertext, '[/' . $tag . ']', $curpos);

				if ($pos !== false)
				{
					$end_pos["$pos"] = 'end';
					$curpos = $pos + $taglen + 3;
				}
			}
			while ($pos !== false);

			if (sizeof($end_pos) == 0) continue;
			$pos_list = $start_pos + $end_pos;
			ksort($pos_list);

			do
			{
				$stack = array();
				$newtext = '';
				$substr_pos = 0;

				foreach ($pos_list AS $pos => $type)
				{
					$stacksize = sizeof($stack);

					if ($type == 'start')
					{
						if ($stacksize == 0) $newtext .= substr($text, $substr_pos, $pos - $substr_pos);
						array_push($stack, $pos);
					}
					else
					{
						// pop off the latest opened tag
						if ($stacksize)
						{
							array_pop($stack);
							$substr_pos = $pos + $taglen + 3;
						}
					}
				}

				$newtext .= substr($text, $substr_pos);

				if ($stack)
				{
					foreach ($stack AS $pos) unset($pos_list["$pos"]);
				}
			}
			while ($stack);

			$text = $newtext;
		}
	}
	if ($vbulletin->smiliecache === null)
	{
		DEVDEBUG('querying for smilies');
		$vbulletin->smiliecache = array();

		$smilies = $db->query_read("
			SELECT *, LENGTH(smilietext) AS smilielen
			FROM " . TABLE_PREFIX . "smilie
			ORDER BY smilielen DESC
		");

		while ($smilie = $db->fetch_array($smilies)) $vbulletin->smiliecache["$smilie[smilieid]"] = $smilie;
	}

	foreach ($vbulletin->smiliecache AS $smilie) $text = str_replace(trim($smilie['smilietext']), '', $text);//!$keepsmile
	$text = strip_bbcode(preg_replace(array('#\[(email|url)=("??)(.+)\\2\]\\3\[/\\1\]#siU', '#\[(thread|post)=("??)(.+)\\2\]\\3\[/\\1\]#siU'), '', $text), false, false, false);
	return ( $vbulletin->options['credits_size_words'] ? count(preg_split('/\s+/', $text)) : strlen(preg_replace('/\s/', '', $text)) );
}

function vbcredits_cache()
{
	$cache = array();
	global $vbulletin;
	$db =& $vbulletin->db;
	$vars = $db->query_write("SHOW VARIABLES LIKE 'max_allowed_packet'");
	$var = $db->fetch_row($vars);
	build_datastore('max_allowed_packet', $var[1], false);
	$currencies = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "credits_currency ORDER BY displayorder ASC");
	$db->free_result($vars);

	while ($currency = $db->fetch_array($currencies))
	{
		$cache['currency'][$currency['currencyid']] = $currency;
	}

	$db->free_result($currencies);
	$displays = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "credits_display WHERE enabled = 1");

	while ($display = $db->fetch_array($displays))
	{
		$display['currencies'] = ( ($display['currencies'] AND $display['currencies'] != 'a:1:{i:0;i:0;}') ? unserialize($display['currencies']) : array() );
		$display['combined'] = ( ($display['combined'] AND $display['combined'] != 'a:1:{i:0;i:0;}') ? unserialize($display['combined']) : array() );
		$cache['display'][$display['displayid']] = $display;
	}

	$db->free_result($displays);
	$actions = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "credits_action ORDER BY category ASC, title ASC");

	while ($action = $db->fetch_array($actions))
	{
		$cache['action'][$action['actionid']] = $action;
	}

	$db->free_result($actions);
	$events = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "credits_event WHERE enabled = 1");

	while ($event = $db->fetch_array($events))
	{
		$event['usergroups'] = ( ($event['usergroups'] AND $event['usergroups'] != 'a:1:{i:0;i:0;}') ? unserialize($event['usergroups']) : array() );
		$event['forums'] = ( ($event['forums'] AND $event['forums'] != 'a:1:{i:0;i:0;}') ? unserialize($event['forums']) : array() );
		$cache['event'][$event['actionid']][$event['currencyid']][$event['eventid']] = $event;
	}

	$db->free_result($events);
	$events = $db->query_read("SELECT DISTINCT eventid, actionid, currencyid FROM " . TABLE_PREFIX . "credits_transaction");

	while ($event = $db->fetch_array($events))
	{
		$history =& $cache['history'][$event['actionid']][$event['currencyid']];
		if (!is_array($history)) $history = array();
		if (!in_array($event['eventid'], $history)) $history[] = $event['eventid'];
	}

	$db->free_result($events);
	build_datastore('vbcredits', serialize($cache), true);
	$vbulletin->vbcredits = $cache;
}

if (defined('VB_AREA') AND VB_AREA == 'AdminCP')
{
	function vbcredits_import($filepath, $currencyid, $verify = true)
	{
		global $vbulletin, $db;
		require_once(DIR . '/includes/class_xml.php');

		$count = 0;
		$xmlobj = new vB_XML_Parser(file_read($filepath));
		if ($xmlobj->error_no == 1) print_stop_message('no_xml_and_no_path');
		if (!$imp = $xmlobj->parse()) print_stop_message('xml_error_x_at_line_y', $xmlobj->error_string(), $xmlobj->error_line());
		if (!is_array($imp['events']['event'])) print_stop_message('no_events_uploaded');

		foreach ($imp['events']['event'] AS $event)
		{	//read each row
			if ($verify AND !array_key_exists($event['actionid'], $vbulletin->vbcredits['action'])) continue;
			$event['currencyid'] = intval($currencyid);
			unset($event['value']);
			$nulls = array();
			$count++;

			foreach (array('enabled', 'moderate') AS $field)
			{	//set bool vals
				$event[$field] = ( $event[$field] ? 1 : 0 );
			}
			foreach (array('main_add' => true, 'main_sub' => true, 'mult_add' => true, 'mult_sub' => true, 'curtarget' => false, 'minaction' => false) AS $field => $float)
			{	//set numeric vals
				$which = ( $float ? 'doubleval' : 'intval' );
				$event[$field] = $which($event[$field]);
			}
			foreach (array('usergroups', 'forums') AS $field)
			{	//serialize the arrays
				$event[$field] = serialize(array_map('intval', explode(',', $event[$field])));
			}
			foreach (array('owner', 'multmin', 'multmax') AS $field)
			{	//if theyre blank they should be null
				if (!is_numeric($event[$field])) $nulls[] = $field . ' = null';
			}

			$maxval = ( $action['cancel'] ? 2 : 1 );
			if ($event['minaction'] > $maxval) $event['minaction'] = $maxval;
			$db->query_write(fetch_query_sql($event, 'credits_event'));
			if (sizeof($nulls) AND $event['eventid'] = $db->insert_id()) $db->query_write("UPDATE " . TABLE_PREFIX . "credits_event SET " . implode(', ', $nulls) . " WHERE eventid = " . $event['eventid']);
		}

		return $count;
	}
}
if (!function_exists('array_intersect_key'))
{	//filter an array for a set of keys you want
	function array_intersect_key($master, $extract)
	{	//only for two arrays!
		foreach (array_keys($master) AS $key)
		{
			if (!array_key_exists($key, $extract)) unset($master[$key]);
		}

		return $master;
	}
}
if (!function_exists('array_combine'))
{	//merge an array of keys and vals
	function array_combine($keys, $vals)
	{
		$combined = array();
		$vals = array_values($vals);
		foreach (array_values($keys) AS $i => $key) $combined[$key] = $vals[$i];
		return $combined;
	}
}
?>
